/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import teamdraco.unnamedanimalmod.common.entity.util.GroundAndSwimmerNavigator;
import teamdraco.unnamedanimalmod.init.UAMItems;

public class MudskipperEntity
extends WaterMobEntity {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(MudskipperEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(MudskipperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public MudskipperEntity(EntityType<? extends MudskipperEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 4){

            public boolean func_75250_a() {
                return super.func_75250_a() && MudskipperEntity.this.func_70090_H();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new WanderGoal(this, 1.0, 15));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FindWaterGoal((CreatureEntity)this));
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundAndSwimmerNavigator((MobEntity)this, world);
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    protected ItemStack getFishBucket() {
        return new ItemStack((IItemProvider)UAMItems.MUDSKIPPER_BUCKET.get());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(5));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    public static boolean checkMudskipperSpawnRules(EntityType<? extends MudskipperEntity> p_223363_0_, IWorld p_223363_1_, SpawnReason p_223363_2_, BlockPos p_223363_3_, Random p_223363_4_) {
        return p_223363_1_.func_180495_p(p_223363_3_).func_203425_a(Blocks.field_150355_j) && p_223363_1_.func_180495_p(p_223363_3_.func_177984_a()).func_203425_a(Blocks.field_150355_j) && p_223363_4_.nextFloat() > 0.6f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_204414_iY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_204412_iW;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_204413_iX;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.MUDSKIPPER_SPAWN_EGG.get());
    }

    protected void func_209207_l(int p_209207_1_) {
    }

    public boolean func_213392_I() {
        return !this.isFromBucket();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.01, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(itemstack1)) {
                p_230254_1_.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final MudskipperEntity mudskipper;

        private WanderGoal(MudskipperEntity mudskipper, double speedIn, int chance) {
            super((CreatureEntity)mudskipper, speedIn, chance);
            this.mudskipper = mudskipper;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final MudskipperEntity fish;

        MoveHelperController(MudskipperEntity fish) {
            super((MobEntity)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.0, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d1 = this.field_75647_c - this.fish.func_226278_cu_();
                double d2 = this.field_75644_d - this.fish.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.fish.func_233637_b_(Attributes.field_233821_d_));
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f1));
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }
}

